/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.armorstatues.api.client.gui.components.LiveSliderButton;
import fuzs.armorstatues.api.client.gui.components.UnboundedSliderButton;
import fuzs.armorstatues.api.client.gui.screens.armorstand.AbstractArmorStandScreen;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandPose;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public abstract class VerticalSliderButton
extends AbstractWidget
implements UnboundedSliderButton,
LiveSliderButton {
    private final int sliderSize = 13;
    private final DoubleSupplier currentValue;
    protected final OnTooltip onTooltip;
    protected double value;

    public VerticalSliderButton(int x, int y, DoubleSupplier currentValue) {
        this(x, y, currentValue, (button, poseStack, mouseX, mouseY) -> {});
    }

    public VerticalSliderButton(int x, int y, DoubleSupplier currentValue, OnTooltip onTooltip) {
        super(x, y, 15, 54, CommonComponents.f_237098_);
        this.currentValue = currentValue;
        this.onTooltip = onTooltip;
        this.refreshValues();
    }

    @Override
    public void refreshValues() {
        this.value = this.currentValue.getAsDouble();
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        if (this.f_93623_) {
            if (this.m_93696_()) {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.slider.usage.focused"));
            } else {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.slider.usage.hovered"));
            }
            this.onTooltip.narrateTooltip(component -> narrationElementOutput.m_169146_(NarratedElementType.HINT, component));
        }
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractArmorStandScreen.ARMOR_STAND_WIDGETS_LOCATION);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        this.m_93228_(poseStack, this.f_93620_, this.f_93621_, 54, 120, this.f_93618_, this.f_93619_);
        int i = this.m_7202_(this.m_198029_());
        this.m_93228_(poseStack, this.f_93620_ + 1, this.f_93621_ + 1 + (int)(this.value * (double)(this.f_93619_ - this.sliderSize - 2)), 151, i * this.sliderSize, this.sliderSize, this.sliderSize);
        if (this.m_198029_()) {
            this.m_7428_(poseStack, mouseX, mouseY);
        }
    }

    public void m_7428_(PoseStack poseStack, int relativeMouseX, int relativeMouseY) {
        this.onTooltip.onTooltip(this, poseStack, relativeMouseX, relativeMouseY);
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseY);
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        this.setValueFromMouse(mouseY);
    }

    private void setValueFromMouse(double mouseY) {
        this.setValue((mouseY - (double)(this.f_93621_ + 8)) / (double)(this.f_93619_ - this.sliderSize - 2));
    }

    private void setValue(double value) {
        this.setValue(value, true);
    }

    private void setValue(double value, boolean snapValue) {
        double oldValue = this.value;
        this.value = Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        if (snapValue) {
            this.value = ArmorStandPose.snapValue(this.value, 0.125);
        }
        if (oldValue != this.value) {
            this.applyValue();
        }
    }

    public void m_7435_(SoundManager handler) {
    }

    public void m_7691_(double mouseX, double mouseY) {
        super.m_7435_(Minecraft.m_91087_().m_91106_());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_93623_ && this.f_93624_) {
            switch (keyCode) {
                case 265: {
                    this.setValue(this.value - 0.035, false);
                    return true;
                }
                case 264: {
                    this.setValue(this.value + 0.035, false);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected abstract void applyValue();

    public static interface OnTooltip {
        public void onTooltip(VerticalSliderButton var1, PoseStack var2, int var3, int var4);

        default public void narrateTooltip(Consumer<Component> contents) {
        }
    }
}

